﻿//////////////////////////////////////////////
// SsaoEffectInfo.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Camera ;
	class Texture ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	struct SsaoEffectInfo
	{
		// Textures to work with
		nkGraphics::Texture* _depthBuffer = nullptr ;

		nkGraphics::Texture* _positionBuffer = nullptr ;
		nkGraphics::Texture* _normalBuffer = nullptr ;

		nkGraphics::Camera* _camera = nullptr ;

		// Parameters
		float _sampleRadius = 0.05f ;
		float _maxOcclusionDistance = 1.f ;
		float _strength = 0.8f ;
		float _depthBias = 0.00001f ;

		unsigned int _kernelSampleCount = 16 ;

		bool _occlusionDrivesAlpha = false ;
		bool _linearDepth = false ;
	} ;
}